<?php

function env(string $key, $default = null) {
    static $loaded = false;

    if (!$loaded) {
        $path = dirname(__DIR__, 2) . '/.env';
        if (is_readable($path)) {
            foreach (file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $line) {
                if (str_starts_with(trim($line), '#')) continue;
                if (!str_contains($line, '=')) continue;

                [$k, $v] = explode('=', $line, 2);
                $k = trim($k);
                $v = trim($v);

                if (!isset($_ENV[$k]) && getenv($k) === false) {
                    $_ENV[$k] = $v;
                    putenv("$k=$v");
                }
            }
        }
        $loaded = true;
    }

    $value = $_ENV[$key] ?? getenv($key);
    return $value !== false ? $value : $default;
}
