<?php

namespace Qbo;

use PDO;
use DateTimeImmutable;

class TokenStore
{
    private PDO $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function get(string $realmId): ?array
    {
        $stmt = $this->pdo->prepare(
            "SELECT * FROM qbo_tokens WHERE realm_id = :realm_id LIMIT 1"
        );
        $stmt->execute(['realm_id' => $realmId]);

        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row ?: null;
    }

    public function save(
        string $realmId,
        string $accessToken,
        string $refreshToken,
        DateTimeImmutable $expiresAt
    ): void {
        $stmt = $this->pdo->prepare(
            "INSERT INTO qbo_tokens
                (realm_id, access_token, refresh_token, expires_at, updated_at)
             VALUES
                (:realm_id, :access_token, :refresh_token, :expires_at, NOW())
             ON DUPLICATE KEY UPDATE
                access_token = VALUES(access_token),
                refresh_token = VALUES(refresh_token),
                expires_at = VALUES(expires_at),
                updated_at = NOW()"
        );

        $stmt->execute([
            'realm_id'      => $realmId,
            'access_token'  => $accessToken,
            'refresh_token' => $refreshToken,
            'expires_at'    => $expiresAt->format('Y-m-d H:i:s'),
        ]);
    }
}
