<?php
require __DIR__ . '/lib/bootstrap.php';

$sources = db_all($pdo, "SELECT * FROM sources WHERE is_enabled=1 ORDER BY id ASC", []);

foreach ($sources as $s) {
  $type = (string)$s['type'];
  try {
    $handler = sources_get($type);
    call_user_func($handler['poll'], $config, $pdo, $s);
  } catch (Exception $e) {
    log_line($config, "poll_sources ERROR source_id={$s['id']} type={$type}: " . $e->getMessage());
  }
}
