<?php
// lib/util/money.php

function to_float($v): ?float {
  if ($v === null) return null;
  if (is_numeric($v)) return (float)$v;
  if (is_string($v) && is_numeric(trim($v))) return (float)trim($v);
  return null;
}

function money(float $v): float {
  return round($v + 0.00000001, 2);
}