<?php
// lib/sources/registry.php

$GLOBALS['SOURCE_REGISTRY'] = [
  // 'NET32' => ['poll' => callable, 'normalize' => callable]
];

function sources_register(string $type, callable $pollFn, callable $normalizeFn): void {
  $type = strtoupper(trim($type));
  $GLOBALS['SOURCE_REGISTRY'][$type] = [
    'poll' => $pollFn,
    'normalize' => $normalizeFn,
  ];
}

function sources_get(string $type): array {
  $type = strtoupper(trim($type));
  $reg = $GLOBALS['SOURCE_REGISTRY'] ?? [];
  if (!isset($reg[$type])) {
    throw new Exception("Unsupported source type: {$type}");
  }
  return $reg[$type];
}

/**
 * ✅ This is what process_queue expects
 */
function source_normalize(string $sourceType, array $raw): array {
  $h = sources_get($sourceType);
  $fn = $h['normalize'] ?? null;
  if (!is_callable($fn)) {
    throw new Exception("Source {$sourceType} normalize handler not callable");
  }
  return $fn($raw);
}

/**
 * Optional (for poll_sources.php)
 */
function source_poll(string $sourceType, array $config, PDO $pdo, array $sourceRow): array {
  $h = sources_get($sourceType);
  $fn = $h['poll'] ?? null;
  if (!is_callable($fn)) {
    throw new Exception("Source {$sourceType} poll handler not callable");
  }
  return $fn($config, $pdo, $sourceRow);
}

/**
 * Register built-in sources here (call after the per-source files are loaded)
 * We'll call this from bootstrap.
 */
function sources_register_defaults(): void {
  // NET32 handlers must exist by the time this runs
  if (function_exists('net32_poll') && function_exists('net32_normalize')) {
    sources_register('NET32', 'net32_poll', 'net32_normalize');
  }
}
