<?php
// lib/qbo/tokens.php

function qbo_tokens_get(PDO $pdo, string $realmId): ?array {
  $st = $pdo->prepare("SELECT * FROM qbo_tokens WHERE realm_id = :rid LIMIT 1");
  $st->execute(['rid' => $realmId]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  return $row ?: null;
}

function qbo_tokens_upsert(PDO $pdo, string $realmId, string $accessToken, string $refreshToken, string $expiresAt): void {
  // $expiresAt should be 'Y-m-d H:i:s' UTC (or your configured timezone consistently)
  $sql = "INSERT INTO qbo_tokens (realm_id, access_token, refresh_token, expires_at, updated_at)
          VALUES (:rid, :at, :rt, :exp, NOW())
          ON DUPLICATE KEY UPDATE
            access_token = VALUES(access_token),
            refresh_token = VALUES(refresh_token),
            expires_at = VALUES(expires_at),
            updated_at = NOW()";
  $st = $pdo->prepare($sql);
  $st->execute([
    'rid' => $realmId,
    'at'  => $accessToken,
    'rt'  => $refreshToken,
    'exp' => $expiresAt,
  ]);
}

function qbo_tokens_is_expiring_soon(string $expiresAt, int $leewaySec): bool {
  // $expiresAt: 'Y-m-d H:i:s'
  $expTs = strtotime($expiresAt);
  if ($expTs === false) return true; // be safe
  return ($expTs - time()) <= $leewaySec;
}
