<?php
// lib/qbo/items.php

// require_once __DIR__ . '/api.php';   // qbo_query()
// require_once __DIR__ . '/util.php';  // qbo_escape()

/**
 * Find a QBO Item by SKU.
 * Uses per-process cache to reduce API calls.
 */
function qbo_find_item_by_sku(array $config, PDO $pdo, int $orderId, string $sku): ?array {
  static $cache = []; // key: realm|sku => item|null

  $sku = trim($sku);
  if ($sku === '') return null;

  $realm = (string)($config['qbo']['realm_id'] ?? '');
  $cacheKey = $realm . '|' . strtoupper($sku);

  if (array_key_exists($cacheKey, $cache)) {
    return $cache[$cacheKey];
  }

  $skuEsc = qbo_escape($sku);

  // QBO SQL query only (qbo_query builds the /v3/company/{realm}/query URL)
  $query = "select * from Item where Sku = '{$skuEsc}' maxresults 1";

  // UPDATED: qbo_query now handles token internally (DB token flow)
  $resp = qbo_query($config, $pdo, $orderId, $query);

  $items = $resp['QueryResponse']['Item'] ?? null;
  if (!is_array($items) || !count($items)) {
    $cache[$cacheKey] = null;
    return null;
  }

  $item = $items[0] ?? null;
  $cache[$cacheKey] = is_array($item) ? $item : null;

  return $cache[$cacheKey];
}

function qbo_find_item_id_by_sku(array $config, PDO $pdo, int $orderId, string $sku): ?string {
  $item = qbo_find_item_by_sku($config, $pdo, $orderId, $sku);
  $id = is_array($item) ? ($item['Id'] ?? null) : null;
  return $id ? (string)$id : null;
}
