<?php
// NOTE:
// Not used during normal order processing.
// Intended for admin/setup tooling to discover QBO custom field DefinitionIds.
// lib/qbo/custom_fields.php

/**
 * Returns SalesFormsPrefs.CustomField array from /preferences
 */
function qbo_salesform_custom_fields(array $config, PDO $pdo, int $orderRowId): array {
  $realm = (string)($config['qbo']['realm_id'] ?? '');
  if ($realm === '') throw new Exception("Missing QBO realm_id");

  $resp = qbo_get($config, $pdo, $orderRowId, "/v3/company/{$realm}/preferences");

  $prefs  = $resp['Preferences'] ?? [];
  $sales  = is_array($prefs) ? ($prefs['SalesFormsPrefs'] ?? []) : [];
  $custom = is_array($sales) ? ($sales['CustomField'] ?? []) : [];

  return is_array($custom) ? $custom : [];
}

/**
 * Finds the DefinitionId for a given custom field Name.
 */
function qbo_custom_field_definition_id(array $customFields, string $name): ?string {
  foreach ($customFields as $cf) {
    if (!is_array($cf)) continue;
    if ((string)($cf['Name'] ?? '') === $name) {
      $id = (string)($cf['DefinitionId'] ?? '');
      return $id !== '' ? $id : null;
    }
  }
  return null;
}

/**
 * Cached lookup per-process for a custom field definition id.
 */
function qbo_custom_field_definition_id_cached(array $config, PDO $pdo, int $orderRowId, string $name): ?string {
  static $cache = [];

  $realm = (string)($config['qbo']['realm_id'] ?? '');
  $key = $realm . '|' . $name;

  if (array_key_exists($key, $cache)) return $cache[$key];

  $fields = qbo_salesform_custom_fields($config, $pdo, $orderRowId);
  $cache[$key] = qbo_custom_field_definition_id($fields, $name);

  return $cache[$key];
}
