<?php
// lib/qbo/address.php

function qbo_build_address(array $addr): ?array {
  // Allow a few common aliases without forcing a new schema
  $streets = [];

  if (isset($addr['streets']) && is_array($addr['streets'])) {
    $streets = $addr['streets'];
  } else {
    // Support typical keys if present
    $aliases = [
      'address1', 'address2', 'address3',
      'street1', 'street2',
    ];
    foreach ($aliases as $k) {
      if (isset($addr[$k]) && trim((string)$addr[$k]) !== '') {
        $streets[] = (string)$addr[$k];
      }
    }

    // Also support line1..line5 (your current behavior)
    for ($i = 1; $i <= 5; $i++) {
      $k = 'line' . $i;
      if (isset($addr[$k]) && trim((string)$addr[$k]) !== '') $streets[] = (string)$addr[$k];
    }
  }

  // Clean and de-dupe blanks
  $lines = [];
  foreach ($streets as $s) {
    $s = trim((string)$s);
    if ($s !== '') $lines[] = $s;
  }

  $city   = trim((string)($addr['city'] ?? ''));
  $region = trim((string)($addr['region'] ?? ($addr['state'] ?? '')));
  $postal = trim((string)($addr['postalCode'] ?? ($addr['postal'] ?? ($addr['zip'] ?? ($addr['postal_code'] ?? '')))));
  $country = trim((string)($addr['country'] ?? ''));

  $out = [];

  // QBO supports Line1..Line5
  $max = min(5, count($lines));
  for ($i = 0; $i < $max; $i++) {
    $out['Line' . ($i + 1)] = $lines[$i];
  }

  if ($city !== '')   $out['City'] = $city;
  if ($region !== '') $out['CountrySubDivisionCode'] = $region; // e.g., NV
  if ($postal !== '') $out['PostalCode'] = $postal;
  if ($country !== '') $out['Country'] = $country; // e.g., US

  return count($out) ? $out : null;
}
