<?php
// lib/bootstrap.php
require __DIR__ . '/../src/Support/env.php';
$config = require __DIR__ . '/../config.php';
require __DIR__ . '/../db.php';

// utils first (because other modules use these)
require __DIR__ . '/util/time.php';
require __DIR__ . '/util/string.php';
require __DIR__ . '/util/log.php';
require __DIR__ . '/util/money.php';
require __DIR__ . '/util/http.php';
require __DIR__ . '/util/redact.php';

// DB helpers
require __DIR__ . '/db/events.php';
require __DIR__ . '/db/http_logs.php';
require __DIR__ . '/db/orders.php';
require __DIR__ . '/db/sources.php';

// QBO modules (auth + API helpers)
require __DIR__ . '/qbo/util.php';
require __DIR__ . '/qbo/auth.php';
require __DIR__ . '/qbo/minorversion.php';
require __DIR__ . '/qbo/address.php';
require __DIR__ . '/qbo/api.php';
require __DIR__ . '/qbo/items.php';
require __DIR__ . '/qbo/customer.php';
require __DIR__ . '/qbo/invoice.php';
require __DIR__ . '/qbo/custom_fields.php';



// source registry + source handlers
require __DIR__ . '/sources/net32/normalize.php';
require __DIR__ . '/sources/net32/poll.php';
require __DIR__ . '/sources/registry.php';


// queue logic
require __DIR__ . '/queue/claim.php';
require __DIR__ . '/queue/backoff.php';
require __DIR__ . '/queue/retry.php';
require __DIR__ . '/queue/processor.php';

date_default_timezone_set($config['timezone'] ?? 'UTC');
ensure_dir($config['log_dir']);

$pdo = db($config);

// --- sanity checks ---
$must = [
  'log_line',
  'http_request',
  'orders_fetch_eligible',
  'orders_claim',
  'order_event',
  'compute_next_retry_at',
  'queue_process_once',
];

$missing = [];
foreach ($must as $fn) {
  if (!function_exists($fn)) $missing[] = $fn;
}

if ($missing) {
  fail($config, "Bootstrap loaded but missing functions: " . implode(', ', $missing));
}

// ---- Register source handlers ----
sources_register('NET32', 'net32_poll', 'net32_normalize');