<?php
// config.php

return [
  'timezone' => 'UTC',

  'log_dir' => __DIR__ . '/logs',

  // Database Credentials
  'db' => [
    'host'    => env('DB_HOST', 'localhost'),
    'name'    => env('DB_NAME'),
    'user'    => env('DB_USER'),
    'pass'    => env('DB_PASS'),
    'charset' => env('DB_CHARSET', 'utf8mb4'),
  ],
  
  'admin' => [
    'allow_force_rerun' => (bool) env('ADMIN_ALLOW_FORCE_RERUN', false), // ✅ enable for sandbox
    'force_rerun_resets_attempts' => true,    // optional
    'force_rerun_run_worker_now' => false,    // optional
  ],

  // QuickBooksOnline API Credentials
  'qbo' => [
    'base_url' => env('QBO_API_BASE_URL'),
    'realm_id' => env('QBO_REALM_ID'),
    'client_id' => env('QBO_CLIENT_ID'),
    'client_secret' => env('QBO_CLIENT_SECRET'),
    'refresh_token' => env('QBO_REFRESH_TOKEN'),

    // Optional: fallback access token if refresh fails
    'access_token' => env('QBO_ACCESS_TOKEN'),

    // Settings
    'taxes_included_in_amount' => false,   // if false, tax will be added as a separate line item (requires tax_item_id config)

    // Item mapping
    'default_item_id' => '1',   // MUST exist in QBO sandbox
    'shipping_item_id' => '',   // optional; else uses default_item_id
    'tax_item_id' => '',        // optional; else uses default_item_id
    
    'token_store_file' => __DIR__ . '/qbo_tokens.json',
    'token_refresh_leeway_sec' => 180, // refresh if expiring within 3 minutes
    
    //Shipping From
    'ship_from' => [
      'line1'      => '3575 W Post Road',
      'city'       => 'Las Vegas',
      'region'     => 'NV',
      'postalCode' => '89118',
      'country'    => 'US',
    ],
    'minor_version' => 75,
    
    'custom_fields' => [
      'po_number_definition_id' => '2', // from your QBO response
      'license_number_definition_id' => '3',
    ],

    
  ],

  // Processing behavior
  'queue' => [
    'batch_size' => 25,           // how many DB orders to process per run
    'max_attempts' => 10,
    'retry_backoff_minutes' => [1, 5, 15, 30, 60, 180], // attempt 1..n
  ],

  // If true: do not POST to QBO, just simulate and log
  'dry_run' => (bool) env('DRY_RUN', false),
];
