<?php
// admin/layouts/app.php
// Usage: render_admin_page($config, $pdo, $pageTitle, function() { ... });

error_reporting(E_ALL);
ini_set('display_errors', 1);


function render_admin_page(array $config, PDO $pdo, string $title, callable $renderContent, array $opts = []): void {
  $active = $opts['active'] ?? ''; // e.g. 'orders'
  $user   = $opts['user'] ?? null; // if you later add auth/session data

  // Basic base path detection for links (adjust if needed)
  $basePath = $opts['basePath'] ?? rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
  $adminBaseUrl = $opts['adminBaseUrl'] ?? null;

  if (!$adminBaseUrl) {
    // Example: /net-32-qbo-sync/admin/orders.php  => /net-32-qbo-sync/admin
    $script = $_SERVER['SCRIPT_NAME'] ?? '';
    $adminBaseUrl = preg_replace('#/admin/.*$#', '/admin', $script);

    // If your admin isn't at /admin but at /net-32-qbo-sync/admin, preserve that:
    // preg_replace keeps everything before /admin
  }
  $adminBaseUrl = rtrim($adminBaseUrl, '/');

  ?>
  <!doctype html>
  <html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= htmlspecialchars($title) ?></title>
    <link rel="stylesheet" href="/net-32-qbo-sync/admin/css/styles.css">

    <style>
      :root{ --bg:#0b1020; --panel:#0f1730; --text:#e8ecff; --muted:#aab3d6; --line:rgba(255,255,255,.08); }
      body{ margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial; background:var(--bg); color:var(--text); }
      a{ color:inherit; text-decoration:none; }
      .app{ display:grid; grid-template-columns:260px 1fr; grid-template-rows:56px 1fr; min-height:100vh; }
      .header{ grid-column:1 / -1; display:flex; align-items:center; justify-content:space-between; padding:0 16px; border-bottom:1px solid var(--line); background:rgba(255,255,255,.03); }
      .sidebar{ grid-row:2; border-right:1px solid var(--line); padding:14px; background:rgba(255,255,255,.02); }
      .content{ grid-row:2; padding:18px; }
      .brand{ font-weight:700; letter-spacing:.2px; }
      .nav a{ display:flex; gap:10px; align-items:center; padding:10px 12px; border-radius:10px; color:var(--muted); }
      .nav a.active{ background:rgba(255,255,255,.06); color:var(--text); }
      .card{ background:rgba(255,255,255,.03); border:1px solid var(--line); border-radius:14px; padding:14px; }
      @media (max-width: 980px){
        .app{ grid-template-columns:1fr; grid-template-rows:56px auto 1fr; }
        .sidebar{ grid-row:2; border-right:0; border-bottom:1px solid var(--line); }
        .content{ grid-row:3; }
      }
    </style>
  </head>

  <body>
    <div class="app">
      <?php include __DIR__ . '/../partials/header.php'; ?>
      <?php include __DIR__ . '/../partials/sidebar.php'; ?>

      <main class="content">
        <?php $renderContent(); ?>
      </main>
    </div>
  </body>
  </html>
  <?php
}
