<?php
// admin/actions/client_update.php

$config = require $_SERVER['DOCUMENT_ROOT'] . '/net-32-qbo-sync/config.php';
require $_SERVER['DOCUMENT_ROOT'] . '/net-32-qbo-sync/db.php';

date_default_timezone_set($config['timezone'] ?? 'UTC');
$pdo = db($config);

function redirect_to_view(int $id, string $tab, string $msgKey, string $msgVal): void {
  header("Location: /net-32-qbo-sync/admin/clients/client_view.php?id={$id}&tab={$tab}&{$msgKey}=" . urlencode($msgVal));
  exit;
}

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$name = trim((string)($_POST['name'] ?? ''));
$isEnabled = isset($_POST['is_enabled']) ? (int)$_POST['is_enabled'] : 1;
$poll = isset($_POST['poll_interval_seconds']) ? (int)$_POST['poll_interval_seconds'] : 300;
$configJson = (string)($_POST['config_json'] ?? '');

if ($id <= 0) {
  header("Location: ../clients.php?msg=" . urlencode("Missing client id"));
  exit;
}

if ($name === '') {
  redirect_to_view($id, 'edit', 'err', 'Name is required.');
}

if ($poll < 30) $poll = 30;
if ($poll > 86400) $poll = 86400;

// Ensure client exists
$client = db_one($pdo, "SELECT id FROM sources WHERE id=?", [$id]);
if (!$client) {
  header("Location: ../clients.php?msg=" . urlencode("Client not found"));
  exit;
}

// Validate JSON
$decoded = json_decode($configJson, true);
if (!is_array($decoded)) {
  redirect_to_view($id, 'edit', 'err', 'Config JSON is invalid. Fix formatting and try again.');
}

// Store compact JSON (or keep pretty if you prefer)
$storedJson = json_encode($decoded, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
if ($storedJson === false) {
  redirect_to_view($id, 'edit', 'err', 'Failed to encode config JSON.');
}

// Update
$stmt = $pdo->prepare("
  UPDATE sources
  SET name = :name,
      is_enabled = :is_enabled,
      poll_interval_seconds = :poll,
      config_json = :cfg,
      updated_at = NOW()
  WHERE id = :id
");
$stmt->execute([
  ':name' => $name,
  ':is_enabled' => $isEnabled ? 1 : 0,
  ':poll' => $poll,
  ':cfg' => $storedJson,
  ':id' => $id,
]);

redirect_to_view($id, 'overview', 'msg', 'Client updated.');
