<?php
// admin/actions/client_create.php

$config = require $_SERVER['DOCUMENT_ROOT'] . '/net-32-qbo-sync/config.php';
require $_SERVER['DOCUMENT_ROOT'] . '/net-32-qbo-sync/db.php';

date_default_timezone_set($config['timezone'] ?? 'UTC');
$pdo = db($config);

function redirect($url) {
  header("Location: {$url}");
  exit;
}

$type = trim((string)($_POST['type'] ?? ''));
$name = trim((string)($_POST['name'] ?? ''));
$isEnabled = isset($_POST['is_enabled']) ? (int)$_POST['is_enabled'] : 1;
$poll = isset($_POST['poll_interval_seconds']) ? (int)$_POST['poll_interval_seconds'] : 300;
$configJson = (string)($_POST['config_json'] ?? '');

if ($type === '' || $name === '') {
  redirect("../client_new.php?err=" . urlencode("Type and name are required."));
}

$allowedTypes = ['net32','woocommerce','amazon_vendor'];
if (!in_array($type, $allowedTypes, true)) {
  redirect("../client_new.php?err=" . urlencode("Invalid type."));
}

if ($poll < 30) $poll = 30;
if ($poll > 86400) $poll = 86400;

$decoded = json_decode($configJson, true);
if (!is_array($decoded)) {
  redirect("../client_new.php?err=" . urlencode("Config JSON is invalid. Please fix formatting."));
}

// Store compact JSON (or keep pretty — your choice)
$storedJson = json_encode($decoded, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
if ($storedJson === false) {
  redirect("../client_new.php?err=" . urlencode("Failed to encode config JSON."));
}

// Insert
$stmt = $pdo->prepare("
  INSERT INTO sources (type, name, is_enabled, poll_interval_seconds, last_polled_at, config_json, created_at, updated_at)
  VALUES (:type, :name, :is_enabled, :poll, NULL, :cfg, NOW(), NOW())
");
$stmt->execute([
  ':type' => $type,
  ':name' => $name,
  ':is_enabled' => $isEnabled ? 1 : 0,
  ':poll' => $poll,
  ':cfg' => $storedJson,
]);

$newId = (int)$pdo->lastInsertId();

redirect("../clients/client_view.php?id={$newId}&tab=overview&msg=" . urlencode("Client created."));
