<?php
// process_queue.php
declare(strict_types=1);

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require __DIR__ . '/lib/bootstrap.php';

// Optional: override dry_run from CLI env
// putenv('DRY_RUN=1');

if (!function_exists('queue_process_once')) {
  fail($config, "queue_process_once() not loaded. Check lib/queue/processor.php and bootstrap requires.");
}

log_line($config, "=== START process_queue ===");

try {
  $n = queue_process_once($config, $pdo);
  log_line($config, "Processed this run: {$n}");
} catch (Throwable $e) {
  fail($config, "Unhandled exception: " . $e->getMessage());
}

log_line($config, "=== END process_queue ===");
exit(0);
