<?php
// lib/util/redact.php

/**
 * Redact secrets from HTTP logs before saving to disk/DB.
 * Keeps structure the same, just masks sensitive header values.
 */
function redact_http(array $config, array $resp): array {
  $out = $resp;

  // redact request headers
  if (isset($out['request']['headers']) && is_array($out['request']['headers'])) {
    $out['request']['headers'] = array_map(function ($h) {
      $line = (string)$h;

      if (stripos($line, 'authorization:') === 0) {
        return 'Authorization: ***REDACTED***';
      }
      if (stripos($line, 'subscription-key:') === 0) {
        return 'Subscription-Key: ***REDACTED***';
      }
      if (stripos($line, 'x-api-key:') === 0) {
        return 'X-Api-Key: ***REDACTED***';
      }
      return $line;
    }, $out['request']['headers']);
  }

  // redact response body tokens if you ever log auth responses directly (optional)
  // Keep it simple for now; we can harden later if needed.

  return $out;
}
