<?php
// lib/queue/retry.php



/**
 * Reset an order so it can be retried immediately
 */
function queue_retry_order(
  array $config,
  PDO $pdo,
  int $orderId,
  bool $force = false
): void {

  $resetAttempts = $force && ($config['admin']['force_rerun_resets_attempts'] ?? false);

  db_exec($pdo, "
    UPDATE orders
    SET
      status = 'RECEIVED',
      next_retry_at = NULL,
      error_code = NULL,
      error_message = NULL,
      updated_at = NOW()
      " . ($resetAttempts ? ", attempt_count = 0" : "") . "
    WHERE id = :id
  ", [
    ':id' => $orderId,
  ]);

  order_event($pdo, $orderId, $force ? 'FORCE_RETRY' : 'MANUAL_RETRY', json_encode([
    'reset_attempts' => $resetAttempts,
  ], JSON_UNESCAPED_SLASHES));
}
