<?php

function queue_claim_order(PDO $pdo, int $orderRowId, int $maxAttempts): int {
  return db_exec($pdo, "
    UPDATE orders
    SET status='PROCESSING',
        attempt_count = attempt_count + 1,
        last_attempt_at = NOW(),
        updated_at = NOW()
    WHERE id = :id
      AND status IN ('RECEIVED','FAILED')
      AND (next_retry_at IS NULL OR next_retry_at <= NOW())
      AND attempt_count < :max_attempts
  ", [
    ':id' => $orderRowId,
    ':max_attempts' => $maxAttempts,
  ]);
}
