<?php
// lib/queue/backoff.php

/**
 * Compute next retry datetime based on attempt count
 */
function compute_next_retry_at(array $config, int $attemptCount): ?string {
  $backoffs = $config['queue']['retry_backoff_minutes'] ?? [1, 5, 15, 30, 60, 180];

  if (!is_array($backoffs) || !count($backoffs)) {
    $backoffs = [5, 15, 30, 60];
  }

  $idx = max(0, $attemptCount - 1);
  $minutes = (int)$backoffs[min($idx, count($backoffs) - 1)];

  return gmdate('Y-m-d H:i:s', time() + ($minutes * 60));
}
