<?php
// lib/qbo/items.php

function qbo_find_item_by_sku(array $config, PDO $pdo, string $token, int $orderId, string $sku): ?array {
  $sku = trim($sku);
  if ($sku === '') return null;

  $skuEsc = qbo_escape($sku);

  // QBO SQL query only (qbo_query builds the /v3/company/{realm}/query URL)
  $query = "select * from Item where Sku = '{$skuEsc}' maxresults 1";

  $resp = qbo_query($config, $pdo, $token, $orderId, $query);

  $items = $resp['QueryResponse']['Item'] ?? null;
  if (!is_array($items) || !count($items)) return null;

  $item = $items[0] ?? null;
  return is_array($item) ? $item : null;
}

function qbo_find_item_id_by_sku(array $config, PDO $pdo, int $orderId, string $sku): ?string {
  return qbo_run_with_auto_refresh($config, function($token) use ($config, $pdo, $orderId, $sku) {
    $item = qbo_find_item_by_sku($config, $pdo, $token, $orderId, $sku);
    $id = $item['Id'] ?? null;
    return $id ? (string)$id : null;
  });
}
