<?php
// lib/qbo_customers.php

function build_customer_display_name_from_normalized(array $n): string {
  $shipName = trim((string)($n['ship_to']['name'] ?? ''));
  $custName = trim((string)($n['customer']['name'] ?? ''));

  if ($shipName !== '' && $custName !== '' && $shipName !== $custName) return "{$shipName} - {$custName}";
  if ($shipName !== '') return $shipName;
  if ($custName !== '') return $custName;

  return "Customer " . ($n['external_order_id'] ?? uniqid());
}

function qbo_find_or_create_customer(array $config, PDO $pdo, string $accessToken, int $orderRowId, array $normalized): string {
  $displayName = build_customer_display_name_from_normalized($normalized);

  $dnEsc = qbo_escape($displayName);
  $query = "select Id, DisplayName from Customer where DisplayName = '{$dnEsc}' maxresults 1";

  $qr = qbo_query($config, $pdo, $accessToken, $orderRowId, $query);
  $id = qbo_first_id($qr, 'Customer');
  if ($id) {
    order_event($pdo, $orderRowId, 'QBO_CUSTOMER_FOUND', json_encode(['customer_id' => $id], JSON_UNESCAPED_SLASHES));
    return $id;
  }

  $payload = ['DisplayName' => $displayName];

  $phone = trim((string)($normalized['customer']['phone'] ?? ''));
  if ($phone !== '') {
    $payload['PrimaryPhone'] = ['FreeFormNumber' => $phone];
  }

  $email = trim((string)($normalized['customer']['email'] ?? ''));
  if ($email !== '') {
    $payload['PrimaryEmailAddr'] = ['Address' => $email];
  }

  $bill = is_array($normalized['bill_to'] ?? null) ? $normalized['bill_to'] : [];
  $addr = build_qbo_address($bill);
  if ($addr) $payload['BillAddr'] = $addr;

  $created = qbo_post($config, $pdo, $accessToken, $orderRowId, "/v3/company/{$config['qbo']['realm_id']}/customer", $payload);
  $createdId = $created['Customer']['Id'] ?? null;
  if (!$createdId) throw new Exception("Failed to extract created Customer.Id");

  order_event($pdo, $orderRowId, 'QBO_CUSTOMER_CREATED', json_encode(['customer_id' => (string)$createdId], JSON_UNESCAPED_SLASHES));
  return (string)$createdId;
}
