<?php
// lib/qbo/auth.php

function qbo_refresh_access_token(array $config): array {
  $tokenUrl = "https://oauth.platform.intuit.com/oauth2/v1/tokens/bearer";

  $clientId = (string)($config['qbo']['client_id'] ?? '');
  $clientSecret = (string)($config['qbo']['client_secret'] ?? '');
  $refreshToken = (string)($config['qbo']['refresh_token'] ?? '');

  if ($clientId === '' || $clientSecret === '' || $refreshToken === '') {
    throw new Exception("Missing QBO client_id/client_secret/refresh_token");
  }

  $basic = base64_encode($clientId . ':' . $clientSecret);

  $headers = [
    "Authorization: Basic {$basic}",
    "Accept: application/json",
    "Content-Type: application/x-www-form-urlencoded",
  ];

  $body = http_build_query([
    'grant_type' => 'refresh_token',
    'refresh_token' => $refreshToken,
  ]);

  $resp = http_request('POST', $tokenUrl, $headers, $body);

  log_http_file($config, 'qbo_refresh', redact_http($config, $resp));

  if ($resp['status'] < 200 || $resp['status'] >= 300) {
    throw new Exception("QBO token refresh failed HTTP {$resp['status']} body=" . truncate((string)$resp['body'], 1200));
  }

  $data = json_decode((string)$resp['body'], true);
  if (!is_array($data) || empty($data['access_token'])) {
    throw new Exception("QBO token refresh: missing access_token");
  }

  return $data;
}
