<?php

function qbo_build_address(array $addr): ?array {
  $streets = [];
  if (isset($addr['streets']) && is_array($addr['streets'])) {
    $streets = $addr['streets'];
  } else {
    for ($i=1; $i<=5; $i++) {
      $k = 'line' . $i;
      if (isset($addr[$k]) && trim((string)$addr[$k]) !== '') $streets[] = (string)$addr[$k];
    }
  }

  $lines = [];
  foreach ($streets as $s) {
    $s = trim((string)$s);
    if ($s !== '') $lines[] = $s;
  }

  $city    = trim((string)($addr['city'] ?? ''));
  $region  = trim((string)($addr['region'] ?? ''));
  $postal  = trim((string)($addr['postalCode'] ?? ($addr['postal'] ?? '')));
  $country = trim((string)($addr['country'] ?? ''));

  $out = [];
  for ($i = 0; $i < min(5, count($lines)); $i++) {
    $out['Line' . ($i + 1)] = $lines[$i];
  }
  if ($city !== '') $out['City'] = $city;
  if ($region !== '') $out['CountrySubDivisionCode'] = $region;
  if ($postal !== '') $out['PostalCode'] = $postal;
  if ($country !== '') $out['Country'] = $country;

  return count($out) ? $out : null;
}
