<?php
// lib/db/http_logs.php

function http_log_db(PDO $pdo, ?int $orderId, string $tag, array $resp): void {
  $req = $resp['request'] ?? ['method'=>null,'url'=>null,'headers'=>null,'body'=>null];

  db_exec($pdo, "
    INSERT INTO http_logs
      (order_id, tag, request_method, request_url, request_headers, request_body, response_status, response_headers, response_body, created_at)
    VALUES
      (:order_id, :tag, :m, :u, :rh, :rb, :s, :hh, :hb, NOW())
  ", [
    ':order_id' => $orderId,
    ':tag' => $tag,
    ':m' => $req['method'] ?? null,
    ':u' => $req['url'] ?? null,
    ':rh' => is_array($req['headers'] ?? null) ? implode("\n", $req['headers']) : (string)($req['headers'] ?? ''),
    ':rb' => (string)($req['body'] ?? ''),
    ':s' => $resp['status'] ?? null,
    ':hh' => (string)($resp['headers'] ?? ''),
    ':hb' => (string)($resp['body'] ?? ''),
  ]);
}
