<?php
// lib/db/events.php

function order_event(PDO $pdo, int $orderId, string $type, $details): void {
  $detailsJson = null;
  if (is_array($details) || is_object($details)) {
    $detailsJson = json_encode($details, JSON_UNESCAPED_SLASHES);
  } elseif (is_string($details)) {
    $detailsJson = $details;
  }

  db_exec($pdo, "
    INSERT INTO order_events (order_id, event_type, details_json, created_at)
    VALUES (?,?,?,NOW())
  ", [$orderId, $type, $detailsJson]);
}
