<?php
// db.php

function db(array $config): PDO {
  static $pdo = null;
  if ($pdo) return $pdo;

  $db = $config['db'];
  $dsn = "mysql:host={$db['host']};dbname={$db['name']};charset={$db['charset']}";
  $pdo = new PDO($dsn, $db['user'], $db['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ]);
  return $pdo;
}

function db_one(PDO $pdo, string $sql, array $params = []): ?array {
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $row = $st->fetch();
  return $row ?: null;
}

function db_all(PDO $pdo, string $sql, array $params = []): array {
  $st = $pdo->prepare($sql);
  $st->execute($params);
  return $st->fetchAll();
}

function db_exec(PDO $pdo, string $sql, array $params = []): int {
  $st = $pdo->prepare($sql);
  $st->execute($params);
  return $st->rowCount();
}