<?php
// admin/partials/sidebar.php

$links = [
  'clients' => ['label' => 'Clients', 'href' => $adminBaseUrl . '/clients/clients.php'],
  'orders' => ['label' => 'Orders', 'href' => $adminBaseUrl . '/orders/orders.php'],
  // add more later:
  // 'settings' => ['label' => 'Settings', 'href' => $adminBaseUrl . '/settings.php'],
];
?>
<aside class="sidebar">
  <nav class="nav">
    <?php foreach ($links as $key => $l): ?>
      <a href="<?= htmlspecialchars($l['href']) ?>" class="<?= ($active === $key ? 'active' : '') ?>">
        <span><?= htmlspecialchars($l['label']) ?></span>
      </a>
    <?php endforeach; ?>
  </nav>

  <div style="margin-top:14px;" class="card">
    <div style="font-weight:600; margin-bottom:6px;">Quick info</div>
    <div style="color:var(--muted); font-size:13px;">
      Environment: <?= htmlspecialchars($config['env'] ?? 'unknown') ?>
    </div>
  </div>
</aside>
