<?php
// admin/client_new.php

$config = require $_SERVER['DOCUMENT_ROOT'] . '/net-32-qbo-sync/config.php';
require $_SERVER['DOCUMENT_ROOT'] . '/net-32-qbo-sync/db.php';
require __DIR__ . '/../layouts/app.php';

date_default_timezone_set($config['timezone'] ?? 'UTC');
$pdo = db($config);

function h($s): string { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$msg = $_GET['msg'] ?? '';
$err = $_GET['err'] ?? '';

$defaultType = $_GET['type'] ?? 'net32';

// Default NET32 template (you can add templates for woo/amazon later)
$defaultConfig = json_encode([
  'base_url' => 'https://api.net32.com',
  'orders_path' => '/orders/pending?isViewed=true',
  'sub_key_header' => 'Subscription-Key',
  'sub_key_value' => '',
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

render_admin_page($config, $pdo, 'New Client', function() use ($msg, $err, $defaultType, $defaultConfig) {
  ?>
  <div class="topbar">
    <div class="wrap">
      <div class="title-row">
        <div>
          <h1>Integrations • New Client</h1>
          <div class="sub">Create a new source (NET32 / WooCommerce / Amazon, etc.)</div>
        </div>
        <div class="actions">
          <a class="btn btn-ghost" style="text-decoration:none" href="clients.php">Back</a>
        </div>
      </div>

      <?php if ($msg): ?><div class="msg"><?= h($msg) ?></div><?php endif; ?>
      <?php if ($err): ?><div class="msg" style="border-color:rgba(239,68,68,.35);background:rgba(239,68,68,.08)"><?= h($err) ?></div><?php endif; ?>
    </div>
  </div>

  <div class="wrap">
    <div class="panel">
      <div class="content">
        <form method="POST" action="/net-32-qbo-sync/admin/actions/client_create.php" style="max-width:980px">
          <div class="grid" style="grid-template-columns:repeat(2,minmax(0,1fr)); margin-top:0">
            <div class="stat">
              <div class="k">Type</div>
              <div class="sub">Start with NET32 (others later)</div>
              <select name="type" required>
                <?php foreach (['net32'=>'NET32','woocommerce'=>'WooCommerce','amazon_vendor'=>'Amazon Vendor'] as $val=>$label): ?>
                  <option value="<?= h($val) ?>" <?= ($defaultType===$val ? 'selected' : '') ?>><?= h($label) ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="stat">
              <div class="k">Name</div>
              <div class="sub">Friendly label (e.g., “Medidenta NET32”)</div>
              <input type="text" name="name" required placeholder="Client name">
            </div>

            <div class="stat">
              <div class="k">Enabled</div>
              <div class="sub">If disabled, polling/processing should skip it</div>
              <select name="is_enabled">
                <option value="1" selected>Enabled</option>
                <option value="0">Disabled</option>
              </select>
            </div>

            <div class="stat">
              <div class="k">Poll Interval (seconds)</div>
              <div class="sub">Default 300 (5 minutes)</div>
              <input type="number" name="poll_interval_seconds" min="30" step="1" value="300" required>
            </div>
          </div>

          <div class="stat" style="margin-top:14px">
            <div class="k">Config JSON</div>
            <div class="sub">Stored in <span class="mono">sources.config_json</span>. Keep valid JSON.</div>
            <textarea name="config_json" rows="12" style="width:100%; font-family: ui-monospace, SFMono-Regular, Menlo, monospace; border-radius:12px; padding:12px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.02); color:inherit;"><?= h($defaultConfig) ?></textarea>
          </div>

          <div style="margin-top:14px; display:flex; gap:10px; align-items:center;">
            <button class="btn" type="submit">Create Client</button>
            <a class="btn btn-ghost" style="text-decoration:none" href="clients.php">Cancel</a>
          </div>

          <div class="muted" style="margin-top:10px; font-size:12px;">
            Note: secrets like API keys will be stored in DB (config_json). Make sure admin is protected.
          </div>
        </form>
      </div>
    </div>

    <div style="height:40px"></div>
  </div>
  <?php
}, [
  'active' => 'clients',
]);
