<?php
require __DIR__ . '/../../lib/bootstrap.php';

if (!($config['admin']['allow_force_rerun'] ?? false)) {
  die('Force rerun disabled');
}

$orderId = 0;

if (isset($_POST['id'])) {
  $orderId = (int)$_POST['id'];
} elseif (isset($_POST['order_id'])) { // backward compatibility
  $orderId = (int)$_POST['order_id'];
} elseif (isset($_GET['id'])) {
  $orderId = (int)$_GET['id'];
}

if ($orderId <= 0) {
  fail($config, "Invalid order ID");
}


queue_retry_order($config, $pdo, $orderId, true);

// Optional: immediately run worker once
if ($config['admin']['force_rerun_run_worker_now'] ?? false) {
  queue_process_once($config, $pdo);
}

header('Location: ../orders.php?msg=forced');
exit;
